/**
 * @package plugin Content - CTRL+S Handler
 * @author Chupurnov Valeriy
 * @copyright (C) 2015 - Chupurnov Valeriy - http://xdan.ru
 * @license GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
**/
(function($){
	var popaper = $('<div class="xdsoft_popap_box"></div>');
	function ctrlsPopap(msgs, classname) {
		var popaptpl = '<div class="xdsoft_dark_background"><div class="{classname}">{msg}</div></div>';
		if (!$.isArray(msgs)) {
			msgs = [msgs];
		}
		var div = [], box;
		for(i=0;i<msgs.length;i+=1) {
			box = $(popaptpl
				.replace('{msg}', msgs[i])
				.replace('{classname}', classname)
			).click(function(){
				$(this).stop().remove();
			})
			div.push(box)
		}
		
		setTimeout(function() {
			$(div).each(function(){
				this.fadeOut(1000, function() {
					$(this).remove();
				})
			})
		}, 5000);
		
		popaper
			.append(div)
	}
	function ctrlsSaveAction(callback) {
		var progress = $('<div style="position:fixed;z-index:10301;top:0px;left:0px;background:rgb(60, 121, 211);height:3px;"></div>');				
		$("body").append(progress);
		$("input[name=task]").val("article.apply");
		$.ajax({
			xhr: function(){
				var xhr = new window.XMLHttpRequest();
				xhr.upload.addEventListener("progress", function(evt){
				  if (evt.lengthComputable) {
					var percentComplete = evt.loaded / evt.total;
					progress
						.stop()
						.animate({width:percentComplete*$(window).width()+"px"},300)
				  }
				}, false);
				xhr.addEventListener("progress", function(evt){
				  if (evt.lengthComputable) {
					var percentComplete = evt.loaded / evt.total;
					progress
						.stop()
						.animate({width:percentComplete*$(window).width()+"px"},300)
				  }
				}, false);
				return xhr;
			},
			type: "POST",
			url: $("#item-form").attr("action"),
			data: $("#item-form").serialize(),
			success: function(data, status){
				progress.stop().remove();
				callback.call(this, data, status);
			}
		});
	}
	$(function(){
		$('body').append(popaper);
	})
	function ctrlSave(event) {
		if (!((event.which == 83)  && event.ctrlKey)) {
			return true;
		}
		if (window['Joomla'] && Joomla["editors"] && Joomla.editors.instances['jform_articletext'] && Joomla.editors.instances['jform_articletext'].getCode) {
			document.getElementById('jform_articletext').value = Joomla.editors.instances['jform_articletext'].getCode();
		}
		if (window['WFEditor']) {
			WFEditor.getContent('jform_articletext');
		}
		if (window['tinyMCE']) {
			tinyMCE.get("jform_articletext").save()
		}
		if(window['CKEDITOR']){
			for(var inst in CKEDITOR.instances)
				 CKEDITOR.instances[inst].updateElement();
		}
		var data = $('#item-form').serialize();
		ctrlsSaveAction(function(resp) {
			var newdoc = $(resp);
			ctrlsPopap(newdoc.find('#system-message-container .alert,#system-message-container .message').html(),newdoc.find('#system-message-container .alert,#system-message-container .message').attr('class'))
			if(newdoc.find('#jform_alias').val()) {
				$('#jform_alias').val(newdoc.find('#jform_alias').val());
			}
			if (newdoc.find('#jform_id').val()) {
				$('#jform_id').val(newdoc.find('#jform_id').val());
				$("#item-form").attr("action", $("#item-form").attr("action").replace(/&id=[0-9]+/,'&id='+$('#jform_id').val()))
			}
			delete newdoc;
		});
		event.preventDefault();
		return false;
	}
	function addCTRLHandlerToAllWindows() {
		$((function(){
			var windows = [window];
			$('body iframe').each(function(){
				windows.push(this.contentWindow || this)
			})
			return windows;
		}())).each(function(){
			if(!this.hasCTRLSHandlerXDSoft) {
				this.hasCTRLSHandlerXDSoft = true;
				$(this).on('keydown', ctrlSave);
			}
		});
		setTimeout(addCTRLHandlerToAllWindows,1000)
	}
	addCTRLHandlerToAllWindows();
}(jQuery))