<?php
/**
 * @package plugin Content - CTRL+S Handler
 * @author Chupurnov Valeriy
 * @copyright (C) 2015 - Chupurnov Valeriy - xdan.ru
 * @license GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
**/

defined('_JEXEC') or die;

jimport('joomla.plugin.plugin');
class plgcontentCTRLS extends JPlugin {
	static public function loadParams() {
        $plugin = JPluginHelper::getPlugin('system', 'jspeedup');
        JLoader::import( 'joomla.version' );
        $version = new JVersion();
        if (version_compare( $version->RELEASE, '1.5', 'eq')) {
            jimport('joomla.html.parameter');
            $params = new JParameter($plugin->params);
        } else {
            $params = new JRegistry($plugin->params);
        }

        return $params;
    }
	function __construct(&$subject, $config = array()) {
		if (!$this->params) {
			$this->params  = $this->loadParams();
		}
		parent::__construct($subject, $config);
	}
	public function getParam($name, $defaultvalue = null) {
		return $this->params->get($name, $defaultvalue)!==null ? $this->params->get($name, $defaultvalue) : $defaultvalue;
	}
	function onContentPrepareForm() {
        $app = JFactory::getApplication();
        if ($app->isAdmin()) {
            if (JFactory::getApplication()->input->get('option', '') != 'com_content') {
				return;
			}
			$doc = JFactory::getDocument();
			if (version_compare( '3.0.0', JVERSION, '>')) {
				$doc->addScript('/plugins/content/ctrls/assets/jquery.js');
			}
			$doc->addScript('/plugins/content/ctrls/assets/ctrls.js');
			if ($this->getParam('use_autosave')) {
				$doc->addScriptDeclaration('setTimeout(function () {
					window.ctrlSaveXDSoft(1);
					setTimeout(arguments.callee, 5000);
				}, 5000);');
			} else if ($this->getParam('use_autosave_every_period')) {
				$period = $this->getParam('autosave_period',30) ? intval($this->getParam('autosave_period',30)) : 30;
				$period*=60*1000;
				$doc->addScriptDeclaration('setTimeout(function () {
					window.ctrlSaveXDSoft(2);
					setTimeout(arguments.callee, '.$period.');
				}, '.$period.');');
			}
			$doc->addStyleSheet('/plugins/content/ctrls/assets/ctrls.css');
			return;
        }
        return true;
    }
}